function fig = AAL3()
% ___________________________________________________________________________
% Main Interface for AUTOMATED ANATOMICAL LABELING procedures used with spm12:
% Local Maxima Labeling : gin_dlabels.m
% Extended Local Maxima Labeling : gin_rclusters.m
% Cluster Labeling : gin_clusters.m
% Each procedure needs Functional Maps spacially normalized 
% using the MNI template.
%
% Copyright 2015 Groupe d'Imagerie Fonctionnelle
% Reference :
% AAL  : N. Tzourio-Mazoyer, B. Landeau, D. Papathanassiou, F. Crivello, O. Étard, N. Delcroix, B. Mazoyer, and M. Joliot (2002) Automated Anatomical Labeling of Activations in SPM Using a Macroscopic Anatomical Parcellation of the MNI MRI Single-Subject Brain. NeuroImage 2002. 15: 273-289. 10.1006/nimg.2001.0978
% AAL2 : E.T. Rolls, M. Joliot, N. Tzourio-Mazoyer (2015) Implementation of a new parcellation of the orbitofrontal cortex in the automated anatomical labeling atlas. NeuroImage 10.1016/j.neuroimage.2015.07.075
% AAL3 : E.T. Rolls, C.C. Huang, C.-P. Lin, J. Feng and M. Joliot (2019) Automated anatomical labelling atlas 3. submitted
% 
% v1.0 Brigitte Landeau	26/01/2006
% v4.0 Marc Joliot & Guillaume Flandin & Gaëlle Leroux 25/08/2015
% v6.0 Marc Joliot 29/08/2019
% ___________________________________________________________________________

h0 = figure('Color',[1 1 1], ...
	'PaperPosition',[18 180 576 432], ...
	'PaperUnits','points', ...
	'Position',[350 250 390 210], ...
	'Tag','Main', ...
	'NumberTitle','off',...
	'Name','ToolBox : AAL3 : GIN, UMR 5296 (2019) for SPM12', ...
	'MenuBar','none', ...
	'ToolBar','none');
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.7020 0.6072 0.3014], ...
	'Position',[72 85 166 16], ...
	'String','Local Maxima Labeling', ...
	'CallBack','gin_dlabels;');
h2 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.7020 0.6072 0.3014], ...
	'Position',[72 60 166 16], ...
	'String','Extended Local Maxima Labeling', ...
	'CallBack','gin_rclusters;');
h3 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.7020 0.60720 0.30140], ...
	'Position',[72 35 166 16], ...
	'String','Cluster Labeling', ...
	'CallBack','gin_clusters;');
h4 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.7020 0.60720 0.30140], ...
	'Position',[72 10 166 16], ...
	'String','Quit', ...
	'CallBack','delete(gcf), spm(''Clear'')');
h5 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'FontSize',14, ...
	'ListboxTop',0, ...
	'Position',[16 136 280 16], ...
	'String','AUTOMATED ANATOMICAL LABELING', ...
	'Style','text', ...
	'Tag','StaticText5');
if nargout > 0, fig = h0; end
